DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_user`(IN `id_user` INT)
    NO SQL
BEGIN

SELECT `id`, `last_ip_address`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `avatar`, `gender`, `group_id` 
FROM `tec_users` 
WHERE `id`=id_user;

END$$
DELIMITER ;

-- **************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_local`(IN `id_local` INT)
    NO SQL
BEGIN

SELECT `id`, `code`, `name`, `address`, `cod_sunat`, `default_warehouse`, `invoice_format`, `bill_format`, `invoice_number`, `bill_number`, `uCrea`, `fCrea`, `uActualiza`, `fActualiza`, `estado` 
FROM `tec_locals` 
WHERE `id`=id_local;

END$$
DELIMITER ;

-- *************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_canal`(IN `id_canal` INT)
    NO SQL
BEGIN

SELECT `id`, `canal` 
FROM `tec_canals` 
WHERE `id`=id_canal;

END$$
DELIMITER ;

-- *************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_warehouse`(IN `id_warehouse` INT)
    NO SQL
BEGIN

SELECT `id`, `warehouse` 
FROM `tec_warehouses` 
WHERE `id`=id_warehouse;

END$$
DELIMITER ;

-- ************************

ALTER TABLE `pro_ventas_importar` ADD `ruc_dni` VARCHAR(50) NULL AFTER `id`;

-- ***********************

ALTER TABLE `pro_ventas_importar` ADD `create_user` INT NOT NULL AFTER `create_date`;

ALTER TABLE `pro_ventas_importar` ADD `update_user` INT NULL AFTER `update_date`;

ALTER TABLE `pro_ventas_importar` ADD `cantidad_item` INT NOT NULL AFTER `tipo_comprobante`;

ALTER TABLE `pro_ventas_importar` ADD `igv` longtext NOT NULL AFTER `afecto`;

-- ************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `regist_ventas_importar`(IN `ruc_dniP` LONGTEXT, IN `expiracionP` VARCHAR(10), IN `tipo_comprobanteP` VARCHAR(1), IN `cantidad_itemP` INT, IN `tipo_docP` VARCHAR(10), IN `num_docP` VARCHAR(50), IN `nombreP` LONGTEXT, IN `direccionP` LONGTEXT, IN `monedaP` VARCHAR(5), IN `estado_comprobanteP` VARCHAR(1), IN `notaP` LONGTEXT, IN `cod_productoP` LONGTEXT, IN `nombre_productoP` LONGTEXT, IN `cantidadP` INT, IN `afectoP` LONGTEXT, IN `igvP` LONGTEXT, IN `inafectoP` LONGTEXT, IN `exoneradoP` LONGTEXT, IN `totalP` LONGTEXT, IN `create_userP` INT, OUT `id_item` INT)
    NO SQL
BEGIN

INSERT INTO `pro_ventas_importar`( 
    `ruc_dni`, `creacion`, `expiracion`, 
    `tipo_comprobante`, `cantidad_item`,
	`tipo_doc`, `num_doc`, 
    `nombre`, `direccion`, `moneda`, 
    `estado_comprobante`, `nota`, `cod_producto`, 
    `nombre_producto`, `cantidad`, `afecto`, 
    `igv`, `inafecto`, `exonerado`,
    `total`, `estado`, `create_date`, 
    `create_user`) 
VALUES (ruc_dniP, CURRENT_TIMESTAMP, expiracionP, 
        tipo_comprobanteP, cantidad_itemP,
		tipo_docP, num_docP,
        nombreP, direccionP, monedaP,
        estado_comprobanteP, notaP, cod_productoP,
        nombre_productoP, cantidadP, afectoP,
        igvP, inafectoP, exoneradoP, 
        totalP, 1, CURRENT_TIMESTAMP, 
        create_userP);
        

SET id_item :=  (SELECT LAST_INSERT_ID());

END$$
DELIMITER ;

-- ************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `validate_tax`()
    NO SQL
BEGIN

SELECT default_tax_rate FROM `tec_settings` ORDER BY `setting_id` DESC limit 1;

END$$
DELIMITER ;

-- ***********************************

ALTER TABLE `tec_sales` ADD `ruc` VARCHAR(50) NULL AFTER `estado`;

ALTER TABLE `tec_sale_items` ADD `ruc` VARCHAR(50) NULL AFTER `tax_method`;

ALTER TABLE `tec_product_mov` ADD `ruc` VARCHAR(50) NULL AFTER `estado`;

ALTER TABLE `tec_warehouse_stock` ADD `ruc` VARCHAR(50) NULL AFTER `stock`;

ALTER TABLE `tec_payments` ADD `ruc` VARCHAR(50) NULL AFTER `updated_at`;

ALTER TABLE `tec_products` ADD `ruc` VARCHAR(50) NULL AFTER `fActualiza`;

ALTER TABLE `tec_customers` ADD `ruc` VARCHAR(50) NULL AFTER `document_type_id`;

-- ***********************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_ventas_registrar_venta`(
IN `dateP` VARCHAR(20), 
IN `local_idP` INT, 
IN `warehouse_idP` INT, 
IN `customer_idP` INT, 
IN `customer_nameP` VARCHAR(55), 
IN `document_typeP` INT, 
IN `currencyP` VARCHAR(3), 
IN `exchangeP` VARCHAR(50), 
IN `affectedP` VARCHAR(50), 
IN `non_affectedP` VARCHAR(50), 
IN `exoneratedP` VARCHAR(50), 
IN `totalP` VARCHAR(50), 
IN `product_discountP` VARCHAR(50), 
IN `order_discount_idP` VARCHAR(20), 
IN `order_discountP` VARCHAR(50), 
IN `total_discountP` VARCHAR(50), 
IN `product_taxP` VARCHAR(50), 
IN `order_tax_idP` VARCHAR(20), 
IN `order_taxP` VARCHAR(50), 
IN `total_taxP` VARCHAR(50), 
IN `tax_ICBPERP` VARCHAR(50), 
IN `mult_ICBPERP` VARCHAR(50), 
IN `subtotalP` VARCHAR(50), 
IN `amountP` VARCHAR(50), 
IN `grand_totalP` VARCHAR(50), 
IN `total_itemsP` INT, 
IN `total_quantityP` VARCHAR(50), 
IN `paidP` VARCHAR(50), 
IN `created_byP` INT, 
IN `updated_byP` INT, 
IN `updated_atP` VARCHAR(20), 
IN `noteP` VARCHAR(1000), 
IN `statusP` VARCHAR(20), 
IN `roundingP` VARCHAR(50), 
IN `attachmentP` VARCHAR(255), 
IN `expiration_dateP` VARCHAR(20), 
IN `canal_idP` INT, 
IN `custom_field_1P` VARCHAR(250), 
IN `custom_field_2P` VARCHAR(250), 
IN `custom_field_3P` VARCHAR(250), 
IN `invoice_idP` VARCHAR(20), 
IN `flg_responseP` INT, 
IN `error_codeP` VARCHAR(15), 
IN `response_descripP` VARCHAR(2000), 
IN `digest_valueP` VARCHAR(250), 
IN `estadoP` INT, 
OUT `result_id` INT, 
OUT `result_invoice` VARCHAR(100), 
IN `itemsSale` LONGTEXT, 
IN `QuantityItemsSale` INT,
IN `rucP` VARCHAR(50),
IN `method_paid` VARCHAR(50)
)
    NO SQL
BEGIN
	DECLARE correlativo VARCHAR(100);
    DECLARE countmin INT;
	DECLARE id_product_valid INT;
	DECLARE id_stock_valid INT;
	DECLARE code_product_valid LONGTEXT;
	
    SET countmin = 1;
    
    IF(document_typeP = 2) THEN
    
        SET correlativo := (SELECT CONCAT("F001-", REPEAT( '0', 7 - LENGTH( invoice_number + 1) ) , invoice_number + 1)  FROM tec_settings);

    ELSE
    
        SET correlativo := (SELECT CONCAT("B001-", REPEAT( '0', 7 - LENGTH( bill_number + 1) ) , bill_number + 1)  FROM tec_settings);

    END IF;



	INSERT INTO `tec_sales`(`date`, `local_id`, `warehouse_id`, `customer_id`, 
                        `customer_name`, `document_type`, `currency`, `exchange`, 
                        `affected`, `non_affected`, `exonerated`, `total`, 
                        `product_discount`, `order_discount_id`, `order_discount`, `total_discount`, 
                        `product_tax`, `order_tax_id`, `order_tax`, `total_tax`, 
                        `tax_ICBPER`, `mult_ICBPER`, `subtotal`, `amount`, 
                        `grand_total`, `total_items`, `total_quantity`, `paid`, 
                        `created_by`, `updated_by`, `updated_at`, `note`, 
                        `status`, `rounding`, `attachment`, `expiration_date`, 
                        `canal_id`, `custom_field_1`, `custom_field_2`, `custom_field_3`, 
                        `invoice_id`, `flg_response`, `error_code`, `response_descrip`, 
                        `digest_value`, `estado`, `ruc`) 
                        VALUES ( dateP, local_idP, warehouse_idP, customer_idP, 
                                customer_nameP, document_typeP, currencyP, exchangeP, 
                                affectedP, non_affectedP, exoneratedP, totalP, 
                                product_discountP, order_discount_idP, order_discountP, total_discountP, 
                                product_taxP, order_tax_idP, order_taxP, total_taxP, 
                                tax_ICBPERP, mult_ICBPERP, subtotalP, amountP, 
                                grand_totalP, total_itemsP, total_quantityP, paidP, 
                                created_byP, updated_byP, updated_atP, noteP, 
                                statusP, roundingP, attachmentP, expiration_dateP, 
                                canal_idP, custom_field_1P, custom_field_2P, custom_field_3P, 
                                correlativo, flg_responseP, error_codeP, response_descripP, 
                                digest_valueP, estadoP, rucP);

    IF(document_typeP = 2) THEN

    	UPDATE tec_settings SET invoice_number = invoice_number + 1;

    ELSE
    
    	UPDATE tec_settings SET bill_number = bill_number + 1;

    END IF;
    
    
    SET result_id :=  (SELECT LAST_INSERT_ID());
    SET result_invoice := (correlativo);
    -- se comento este while ya que no se tenia version MySQL 5.7 o MariaDB 10.4
	
	IF(paidP > 0) THEN
		INSERT INTO `tec_payments`(`date`, `sale_id`, 
		`customer_id`, `paid_by`, `amount`, 
		`currency`, `created_by`,  `note`, 
		`pos_paid`, `pos_balance`, `gc_no`, `ruc`) 
		VALUES (dateP, result_id, 
		customer_idP, method_paid, paidP,
		currencyP, created_byP, '',
		paidP, 0.00, '', rucP);
    END IF;
	
    WHILE countmin < QuantityItemsSale DO
	
	 SET code_product_valid := REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.code') AS 'Result') ,'"','');
	
	 SET id_product_valid :=(SELECT `id` 
							 FROM `tec_products` 
							 WHERE 
							 `code`= code_product_valid
							 and `estado`=1 and ruc=rucP);
	 
	 IF (id_product_valid IS NULL) THEN
	 
	 SET id_product_valid :=0;
	 
	 END IF;
   
     INSERT INTO `tec_sale_items`(`sale_id`, `product_id`, `code`, 
                                  `name`, `quantity`, `unit_price`, 
                                  `affect_price`, `non_affected_price`, `exonerated_price`, 
                                  `discount`, `item_discount`, `prr_discount`, 
                                  `tax`, `item_tax`, `igv`, `tax_ICBPER`, 
                                  `quantity_ICBPER`, `subtotal`, `real_unit_price`, 
                                  `currency_cost`, `cost`, `tax_method`, `ruc`) 
                                  VALUES (
          result_id,
          -- REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.product_id') AS 'Result') ,'"','') ,
		  id_product_valid, 
          -- REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.code') AS 'Result') ,'"','') ,
          code_product_valid,
		  REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.name') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Quantity') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Unit_price') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Affect_price') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Non_affected_price') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Exonerated_price') AS 'Result') ,'"','') ,
		  REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.discount') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.item_discount') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.prr_discount') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Tax') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Item_tax') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Igv') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Tax_ICBPER') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Quantity_ICBPER') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Subtotal') AS 'Result') ,'"',''),
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.real_unit_price') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.currency_cost') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.cost') AS 'Result') ,'"','') ,
          REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.tax_method') AS 'Result') ,'"',''),
		  rucP);
		 
		 IF (id_product_valid > 0) THEN
		 
			INSERT INTO `tec_product_mov`(`origin_id`, `local_id`, `warehouse_id`, `product_id`, `cant`, `tipo`, `idMotivo`, `ref`, `uCrea`, `fCrea`, `estado`, `ruc`) 
			VALUES (result_id, local_idP, warehouse_idP, 
			-- REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.product_id') AS 'Result') ,'"',''),
			id_product_valid,
			REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Quantity') AS 'Result') ,'"','') ,
			'S', 5, correlativo, created_byP, dateP, 1, rucP);
			
			SET id_stock_valid :=(SELECT `id` 
									FROM `tec_warehouse_stock` 
									WHERE `warehouse_id`= warehouse_idP
									and `product_id`= id_product_valid);
			
			IF (id_stock_valid IS NULL) THEN
			
				INSERT INTO `tec_warehouse_stock`(`warehouse_id`, `product_id`, `stock`, `ruc`) 
				VALUES (warehouse_idP, 
				-- REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.product_id') AS 'Result') ,'"',''),
				id_product_valid,
				(0 - (REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Quantity') AS 'Result') ,'"',''))),
				rucP);
			
			ELSE
			
				UPDATE `tec_warehouse_stock` 
				SET `stock`= `stock` - REPLACE((SELECT JSON_EXTRACT(JSON_EXTRACT(JSON_EXTRACT(itemsSale, '$.items'), CONCAT('$."',countmin,'"')), '$.Quantity') AS 'Result') ,'"','')
				WHERE `id`= id_stock_valid and `ruc`=rucP;
			
			END IF;
			
			
		 END IF;
         
         SET countmin = countmin + 1;
        
    END WHILE;
END$$
DELIMITER ;


-- *************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_tipo_cliente`(IN `id_tipo` INT)
    NO SQL
BEGIN

SELECT `id`, `customers_type` 
FROM `tec_customers_type` 
WHERE `id`=id_tipo;

END$$
DELIMITER ;

-- ************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_tipo_documento`(IN `id_tipo` INT)
    NO SQL
BEGIN

SELECT `id`, `document_type`, `abreviatura` 
FROM `tec_document_type` 
WHERE `id`=id_tipo;

END$$
DELIMITER ;

-- **************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_alm_registrar_producto`(
IN `codeP` VARCHAR(50), 
IN `nameP` CHAR(255), 
IN `category_idP` INT, 
IN `currencyP` VARCHAR(3), 
IN `priceP` DECIMAL(25,2), 
IN `imageP` VARCHAR(255), 
IN `taxP` VARCHAR(20), 
IN `costP` DECIMAL(25,2), 
IN `tax_methodP` TINYINT, 
IN `quantityP` DECIMAL(25,2), 
IN `barcode_symbologyP` VARCHAR(20), 
IN `typeP` VARCHAR(20), 
IN `detailsP` TEXT, 
IN `alert_quantityP` DECIMAL(10,2), 
IN `maker_idP` INT, 
IN `presentationP` VARCHAR(250), 
IN `uCreaP` INT, 
OUT `id_product` INT,
IN `rucP` VARCHAR(50),
IN `warehouse_idP` INT
)
    NO SQL
BEGIN

INSERT INTO `tec_products`(`code`, `name`, `category_id`, `currency`, 
                           `price`, `image`, `tax`, `cost`, `tax_method`, 
                           `quantity`, `barcode_symbology`, `type`, 
                           `details`, `alert_quantity`, `maker_id`, 
                           `presentation`, `estado`, `uCrea`, `fCrea`, `ruc`) 
VALUES (codeP, nameP, category_idP, currencyP,
        priceP, imageP, taxP, costP, tax_methodP,
		quantityP, barcode_symbologyP, typeP,
        detailsP, alert_quantityP, maker_idP,
        presentationP, 1, uCreaP, CURRENT_TIMESTAMP, rucP);
        
SET id_product :=  (SELECT LAST_INSERT_ID());

INSERT INTO `tec_warehouse_stock`(`warehouse_id`, `product_id`, `stock`, `ruc`) 
VALUES (warehouse_idP, id_product, 0, rucP);


END$$
DELIMITER ;

-- **************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_Categories`(IN `Categories_id` INT)
    NO SQL
BEGIN

SELECT `id`, `code`, `parent_category_id`, `name`, `image` 
FROM `tec_categories` 
WHERE `id`=Categories_id;

END$$
DELIMITER ;

-- *****************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `valid_maker`(IN `id_maker` INT)
    NO SQL
BEGIN

SELECT `id`, `maker` 
FROM `tec_makers` 
WHERE `id`=id_maker;

END$$
DELIMITER ;

-- ***************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `update_ventas_importar`(IN `id_item` INT, IN `user` INT)
    NO SQL
BEGIN

UPDATE `pro_ventas_importar` SET `estado`=2,`update_date`=CURRENT_TIMESTAMP,`update_user`=user
WHERE `id`=id_item;

END$$
DELIMITER ;


-- **************************************

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `sp_alm_producto_consul_ruc`(IN `id_code` VARCHAR(50), IN `rucP` VARCHAR(50))
    NO SQL
BEGIN
-- select if(concat("a", code)=id_code, "si","no"), concat("a", code)
-- from tec_products;
SELECT id, code, name 
FROM tec_products 
WHERE code = concat(id_code, '') and estado = 1 and ruc=rucP;

END$$
DELIMITER ;

-- **************************************

DROP PROCEDURE IF EXISTS `validate_customer`;

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `validate_customer`
(IN `numIdentif` VARCHAR(20),
IN `rucEmp` VARCHAR(50))
    NO SQL
BEGIN

        SELECT id, name, cf1, cf2, direccion, document_type_id 
		FROM tec_customers 
		WHERE (cf2 = numIdentif or cf1 = numIdentif) and estado = 1 and ruc=rucEmp
		limit 1;

END$$
DELIMITER ;

-- **************************************

DROP PROCEDURE IF EXISTS `register_customer`;

DELIMITER $$
CREATE DEFINER=`root`@`localhost` PROCEDURE `register_customer`
(OUT `result_id` INT, IN `nameP` VARCHAR(55), IN `cf1P` VARCHAR(255), 
IN `cf2P` VARCHAR(255), IN `phoneP` VARCHAR(20), IN `emailP` VARCHAR(100), 
IN `direccionP` VARCHAR(300), IN `customers_type_idP` INT, IN `estadoP` INT, 
IN `person_typeP` VARCHAR(20), IN `document_type_idP` INT, IN `rucEmp` VARCHAR(50))
    NO SQL
BEGIN



INSERT INTO `tec_customers`(`name`, `cf1`, `cf2`, 
                            `phone`, `email`, `direccion`, 
                            `customers_type_id`, `estado`, `person_type`, 
                            `document_type_id`, `ruc`) VALUES (
                                nameP, cf1P, cf2P,
                            	phoneP, emailP, direccionP,
                            	customers_type_idP, estadoP, person_typeP,
                            	document_type_idP, rucEmp);

SET result_id :=  (SELECT LAST_INSERT_ID());

END$$
DELIMITER ;
